// src/background.js
let pendingVideoId = null;

// content script로부터의 메시지 처리
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  // 메시지 처리가 비동기적으로 이루어질 수 있음을 알림
  let isResponseAsync = false;

  try {
    if (request.action === 'ADD_TO_TEETUBE') {
      pendingVideoId = request.videoId;
      // 기본 팝업 열기
      chrome.action.openPopup();
      sendResponse({ success: true });
    }
    else if (request.action === 'GET_PENDING_VIDEO') {
      sendResponse({ videoId: pendingVideoId });
    }
    else if (request.action === 'CLEAR_PENDING_VIDEO') {
      pendingVideoId = null;
      sendResponse({ success: true });
    }
  } catch (error) {
    console.error('Error handling message:', error);
    sendResponse({ success: false, error: error.message });
  }

  // 비동기 응답이 필요한 경우 true를 반환
  return isResponseAsync;
});